//********************************************************************
//  StairSteps.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.21 (5E, p. 288)
//********************************************************************

import javax.swing.JApplet;
import java.awt.*;

public class StairSteps extends JApplet
{
   private final int NUM_STEPS = 15;
   private final int STAIR_HEIGHT = 15;
   private final int STAIR_DEPTH = 15;
   private final int START_X = 20;
   private final int START_Y = 300 - STAIR_DEPTH;

   //-----------------------------------------------------------------
   //  Paints a side view of some stair steps.
   //-----------------------------------------------------------------
   public void paint(Graphics page)
   {
      int stepX = START_X, stepY = START_Y;

      setBackground (Color.cyan);
      page.setColor (Color.black);

      for (int count=1; count <= NUM_STEPS; count++)
      {
         page.drawLine (stepX, stepY, stepX, stepY + STAIR_HEIGHT);
         page.drawLine (stepX, stepY, stepX + STAIR_DEPTH, stepY);

         stepX += STAIR_DEPTH;
         stepY -= STAIR_HEIGHT;
      }
   }
}
